(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10001,        254]
NotebookOptionsPosition[      9668,        239]
NotebookOutlinePosition[     10012,        254]
CellTagsIndexPosition[      9969,        251]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"x", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", "*", "a"}], "+", "b", "+", "1"}], ")"}]}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
         RowBox[{"AxesStyle", "\[Rule]", "Thick"}], ",", 
         RowBox[{"Ticks", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"Pi", "/", "4"}], ",", 
              RowBox[{"Pi", "/", "2"}], ",", 
              RowBox[{
               RowBox[{"3", "/", "4"}], "Pi"}], ",", "Pi"}], "}"}], ",", 
            "Automatic"}], "}"}]}], ",", 
         RowBox[{"LabelStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"FontSize", "\[Rule]", "24"}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], 
           "]"}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "0", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "0", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Gray"}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5619043977436223`*^9, 3.561904466586543*^9}, {
  3.5619051277001047`*^9, 3.561905187292209*^9}, {3.5619052438735085`*^9, 
  3.561905246946714*^9}, {3.561905311889628*^9, 3.5619053719341335`*^9}, {
  3.561905405942193*^9, 3.561905427236231*^9}, {3.561907536283935*^9, 
  3.561907547952756*^9}, {3.561907591913633*^9, 3.5619076944994125`*^9}, {
  3.561907750955912*^9, 3.561907758069525*^9}, {3.562511454978367*^9, 
  3.56251146820719*^9}}],

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"ContourPlot", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"x", "*", "a"}], "]"}], 
           RowBox[{
            RowBox[{"Sin", "[", 
             RowBox[{"y", "*", "b"}], "]"}], "/", "2"}]}], "+", 
          RowBox[{"1", "/", "2"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", "0", ",", "Pi"}], "}"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
         RowBox[{"ColorFunction", "\[Rule]", "\"\<TemperatureMap\>\""}], ",", 
         RowBox[{"ColorFunctionScaling", " ", "\[Rule]", "False"}], ",", 
         RowBox[{"Contours", "\[Rule]", "20"}], ",", 
         RowBox[{"AxesStyle", "\[Rule]", "Thick"}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", "Thick"}], ",", 
         RowBox[{"FrameTicks", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"Pi", "/", "4"}], ",", 
                RowBox[{"Pi", "/", "2"}], ",", 
                RowBox[{
                 RowBox[{"3", "/", "4"}], "Pi"}], ",", "Pi"}], "}"}], ",", 
              "None"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", 
                RowBox[{"Pi", "/", "4"}], ",", 
                RowBox[{"Pi", "/", "2"}], ",", 
                RowBox[{
                 RowBox[{"3", "/", "4"}], "Pi"}], ",", "Pi"}], "}"}], ",", 
              "None"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"PlotRangePadding", "\[Rule]", "0"}], ",", 
         RowBox[{"LabelStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"FontSize", "\[Rule]", "28"}], ",", 
            RowBox[{"FontWeight", "\[Rule]", "Bold"}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}],
          ",", 
         RowBox[{"Mesh", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"3", ",", "3"}], "}"}]}], ",", 
         RowBox[{"MeshFunctions", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#1", "&"}], ",", 
            RowBox[{"#2", "&"}]}], "}"}]}], ",", 
         RowBox[{"MeshStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Thickness", "[", "0.003", "]"}], "]"}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Gray"}], "]"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5619045053994117`*^9, 3.5619045060858126`*^9}, {
   3.5619045948187685`*^9, 3.5619046060819883`*^9}, {3.561904682319322*^9, 
   3.561904725468998*^9}, {3.5619055284960084`*^9, 3.5619055711464834`*^9}, {
   3.5619056208481703`*^9, 3.561905642735009*^9}, {3.5619060247796803`*^9, 
   3.5619060283676863`*^9}, {3.5619060735765657`*^9, 
   3.5619061054162216`*^9}, {3.5619070850375423`*^9, 
   3.5619070909187527`*^9}, {3.5619071224620085`*^9, 3.561907123054809*^9}, {
   3.5619071580456705`*^9, 3.5619071716332946`*^9}, 3.5619072068113565`*^9, {
   3.561907259336649*^9, 3.561907263626656*^9}, {3.5619073089291353`*^9, 
   3.561907373544449*^9}, {3.5619074163821244`*^9, 3.5619074204537315`*^9}, 
   3.561907500965473*^9, 3.562511476880805*^9}],

Cell[BoxData[
 RowBox[{"GraphicsGrid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Plot3D", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"x", "*", "a"}], "]"}], 
          RowBox[{"Sin", "[", 
           RowBox[{"y", "*", "b"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"y", ",", "0", ",", "Pi"}], "}"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
         RowBox[{"ColorFunction", "\[Rule]", 
          RowBox[{"Function", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
            RowBox[{"ColorData", "[", 
             RowBox[{"\"\<TemperatureMap\>\"", ",", 
              RowBox[{
               RowBox[{"z", "/", "2"}], "+", 
               RowBox[{"1", "/", "2"}]}]}], "]"}]}], "]"}]}], ",", 
         RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
         RowBox[{"Ticks", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"Pi", "/", "4"}], ",", 
              RowBox[{"Pi", "/", "2"}], ",", 
              RowBox[{
               RowBox[{"3", "/", "4"}], "Pi"}], ",", "Pi"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"Pi", "/", "4"}], ",", 
              RowBox[{"Pi", "/", "2"}], ",", 
              RowBox[{
               RowBox[{"3", "/", "4"}], "Pi"}], ",", "Pi"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"BoxStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
         RowBox[{"TicksStyle", "\[Rule]", "Thick"}], ",", 
         RowBox[{"LabelStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{
            RowBox[{"FontSize", "\[Rule]", "24"}], ",", 
            RowBox[{"FontWeight", "\[Rule]", "Bold"}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], 
           "]"}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "1", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Gray"}], "]"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "1200"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5619047692738748`*^9, 3.5619047962619224`*^9}, {
  3.5619056800346746`*^9, 3.561905732544367*^9}, {3.5619061511087017`*^9, 
  3.5619061808589544`*^9}, {3.5619062920569496`*^9, 3.561906299045762*^9}, {
  3.5619067141936913`*^9, 3.5619068032854476`*^9}, {3.5619068371375074`*^9, 
  3.561906903702824*^9}, {3.561906934091677*^9, 3.5619069761649513`*^9}, {
  3.5625114895948277`*^9, 3.562511516208474*^9}, {3.562511660259127*^9, 
  3.5625116633323326`*^9}}]
},
WindowSize->{1902, 906},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 2076, 50, 52, "Input"],
Cell[2624, 72, 3727, 85, 92, "Input"],
Cell[6354, 159, 3310, 78, 92, "Input"]
}
]
*)

(* End of internal cache information *)
